# Code for generating the graph of Fig 11c

rm(list=ls())

require(likert)
require(RColorBrewer)
require(cowplot)

questions = c("1. Allowed to effectively navigate the video", "2. Helped me follow the teacher's instructions", "3. Helped me understand the concepts in the video")
answers = c("strongly disagree", "somewhat disagree", "neutral",  "somewhat agree", "strongly agree")


myColor = c("#e34a33", "#fc8d59", "#DEDEDE","#bae4b3", "#74c476")


getLikert <- function(dataset, system){
	data = dataset[dataset$system==system,][-c(1,2,3)]
	data = data + 1

	data$navigate = answers[data$navigate]
	data$navigate = factor(data$navigate, levels = answers, ordered = TRUE)

	data$follow = answers[data$follow]
	data$follow = factor(data$follow, levels = answers, ordered = TRUE)

	data$understand = answers[data$understand]
	data$understand = factor(data$understand, levels = answers, ordered = TRUE)

	data
}


data = read.csv("stivi-vs-baseline.csv", sep=",", header=TRUE, strip.white=TRUE)

data1 = getLikert(data, "baseline")
plot1 = plot(likert(data1), type="bar", centered = FALSE, plot.percent.low = FALSE, plot.percent.high = FALSE, plot.percent.neutral = FALSE)  + labs(title = "Baseline") + scale_fill_manual(values = brewer.pal(n=5,"RdYlGn")) 
#plot1 = plot(likert(data1),type="bar", scale_fill_manual(values = myColor))

data2 = getLikert(data,"stivi")
plot2 = plot(likert(data2), type="bar", centered = FALSE, plot.percent.low = FALSE, plot.percent.high = FALSE, plot.percent.neutral = FALSE) +  labs(title = "STIVi") + scale_fill_manual(values = brewer.pal(n=5,"RdYlGn"))

grid = plot_grid(plot1, plot2)
print(grid)
